#include "dailymotionauthdialog.h"
#include "../base/session.h"
#include "webview.h"
#include <QProgressBar>
#include <QGridLayout>

DailymotionAuthDialog::DailymotionAuthDialog(Session *session, const QString &accountName, QWidget *parent) :
    AbstractDialog(parent),
    m_session(session),
    m_name(accountName),
    m_webView(new WebView(this)),
    m_progressBar(new QProgressBar(this)),
    m_grid(new QGridLayout(this))
{
    this->setWindowTitle(tr("Dailymotion authorisation"));

    m_grid->addWidget(m_webView, 0, 0);
    m_grid->addWidget(m_progressBar, 1, 0);
    m_webView->setUrl(m_session->dailymotion()->authUrl());
    m_webView->enableSelectionSuppressor();
    m_progressBar->setTextVisible(false);

    this->connect(m_webView, SIGNAL(urlChanged(QUrl)), this, SLOT(checkUrlForCode(QUrl)));
    this->connect(m_webView, SIGNAL(loadProgress(int)), m_progressBar, SLOT(setValue(int)));
    this->connect(m_webView, SIGNAL(loadStarted()), m_progressBar, SLOT(show()));
    this->connect(m_webView, SIGNAL(loadFinished(bool)), m_progressBar, SLOT(hide()));

    this->onOrientationChanged();
}

void DailymotionAuthDialog::checkUrlForCode(const QUrl &url) {
    if (url.hasQueryItem("code")) {
        m_session->dailymotion()->signIn(m_name, url);
        this->accept();
    }
    else if (url.queryItemValue("reason") == "access_denied") {
        m_session->onInfo(tr("You have denied access to your Dailymotion account"));
        this->reject();
    }
}
