#ifndef ARCHIVEWINDOW_H
#define ARCHIVEWINDOW_H

#include "stackedwindow.h"

class Session;
class ArchiveListModel;
class ListView;
class FilterBox;
class QMenu;
class QAction;
class QLabel;
class QVBoxLayout;
class QModelIndex;

class ArchiveWindow : public StackedWindow
{
    Q_OBJECT
public:
    explicit ArchiveWindow(Session *session, StackedWindow *parent);
    void keyPressEvent(QKeyEvent *event);
    
private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onDirectoryLoaded();
    void onItemClicked(const QModelIndex &index);
    void showContextMenu(const QPoint &pos);
    void showConfirmDeleteDialog();
    void deleteVideo();
    void showFilterBox();

private:
    ArchiveListModel *m_model;
    ListView *m_listView;
    FilterBox *m_filterBox;
    QMenu *m_contextMenu;
    QAction *m_deleteAction;
    QLabel *m_noResultsLabel;
    QVBoxLayout *m_vbox;
};

#endif // ARCHIVEWINDOW_H
