#ifndef YOUTUBECOMMENTLISTMODEL_H
#define YOUTUBECOMMENTLISTMODEL_H

#include "abstractcommentlistmodel.h"

class Session;

class YouTubeCommentListModel : public AbstractCommentListModel
{
    Q_OBJECT

    Q_PROPERTY(Session* session
               READ session
               WRITE setSession)
    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)
    Q_PROPERTY(bool loading
               READ loading
               NOTIFY loadingChanged)
    Q_PROPERTY(QString feed
               READ feed
               WRITE setFeed)
    Q_PROPERTY(QString videoId
               READ videoId
               WRITE setVideoId)

public:
    explicit YouTubeCommentListModel(Session *session = 0, QObject *parent = 0);
    inline Session* session() const { return m_session; }
    void setSession(Session *session);
    inline QString videoId() const { return m_videoId; }
    void setVideoId(const QString &id = QString());
    inline QString feed() const { return m_feed; }
    inline void setFeed(const QString &afeed) { m_feed = afeed; }
    inline bool loading() const { return m_loading; }

public slots:
    void clear();
    void reset();
    void getComments(const QString &id = QString());
    void getMoreComments();
    void getInitialComment(int row);

private slots:
    void addComments();
    inline void onError() { setError(true); setLoading(false); }
    void insertInitialComment(QSharedPointer<CommentItem> comment);
    void onCommentAdded(QSharedPointer<CommentItem> comment);
    void onCommentError();

private:
    inline void setLoading(bool loading) { m_loading = loading; emit loadingChanged(loading); }
    inline bool moreResults() const { return m_moreResults; }
    inline void setMoreResults(bool more) { m_moreResults = more; }
    inline int offset() const { return m_offset; }
    inline void setOffset(int offset) { m_offset = offset; }
    inline bool error() const { return m_error; }
    inline void setError(bool error) { m_error = error; }

signals:
    void loadingChanged(bool loading);
    void countChanged(int count);

private:
    Session *m_session;
    QString m_videoId;
    QString m_feed;
    bool m_loading;
    int m_replyRow;
    bool m_moreResults;
    bool m_error;
    int m_offset;
};

#endif // YOUTUBECOMMENTLISTMODEL_H
