#ifndef SOCIALVIDEOLISTMODEL_H
#define SOCIALVIDEOLISTMODEL_H

#include "videoitem.h"
#include <QAbstractListModel>
#include <QSharedPointer>

class Session;
class ThumbnailCache;

class SocialVideoListModel : public QAbstractListModel
{
    Q_OBJECT

    Q_PROPERTY(Session* session
               READ session
               WRITE setSession)
    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)
    Q_PROPERTY(bool itemsSelected
               READ itemsSelected
               NOTIFY itemsSelectedChanged)

public:
    enum Roles {
        IdRole = Qt::UserRole + 1,
        VideoIdRole,
        FavouriteIdRole,
        PlaylistVideoIdRole,
        TitleRole,
        ArtistRole,
        DateRole,
        DurationRole,
        ViewCountRole,
        RatingCountRole,
        RatingRole,
        ThumbnailRole,
        ThumbnailUrlRole,
        ArchiveRole,
        ServiceRole,
        FavouriteRole,
        SelectedRole,
        ThumbnailPressedRole
    };

public:
    explicit SocialVideoListModel(Session *session = 0, QObject *parent = 0);
    ~SocialVideoListModel();
    inline Session* session() const { return m_session; }
    void setSession(Session *session);
    inline ThumbnailCache* thumbnailCache() const { return m_cache; }
    void setThumbnailCache(ThumbnailCache *cache);
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role = Qt::DisplayRole) const;
    QSharedPointer<VideoItem> get(int row) const;
    Q_INVOKABLE VideoItem* getFromQML(int row) const;
    Q_INVOKABLE QList<int> selectedRows() const { return m_selectedRows; }
    QList< QSharedPointer<VideoItem> > selectedItems() const;
    Q_INVOKABLE QList<VideoItem*> selectedItemsFromQML() const;
    inline bool itemsSelected() const { return !this->selectedRows().isEmpty(); }

public slots:
    void selectAll();
    void selectNone();
    void toggleSelected(int row);
    void downloadSelectedVideos(bool saveAsAudio = false);
    void queueSelectedVideos();

private slots:
    void onVideoAdded(int row);
    void onThumbnailReady();

signals:
    void countChanged(int count);
    void itemsSelectedChanged(bool selected);

private:
    Session *m_session;
    ThumbnailCache *m_cache;
    QList<int> m_selectedRows;
    int m_thumbnailPressedRow;
};

#endif // SOCIALVIDEOLISTMODEL_H
