#ifndef ABSTRACTGROUPLISTMODEL_H
#define ABSTRACTGROUPLISTMODEL_H

#include "groupitem.h"
#include <QAbstractListModel>
#include <QSharedPointer>

class ThumbnailCache;

class AbstractGroupListModel : public QAbstractListModel
{
    Q_OBJECT

public:
    enum Roles {
        IdRole = Qt::UserRole + 1,
        TitleRole,
        ArtistRole,
        DateRole,
        VideoCountRole,
        ThumbnailRole,
        ThumbnailUrlRole,
        DescriptionRole
    };

public:
    explicit AbstractGroupListModel(ThumbnailCache *cache = 0, QObject *parent = 0);
    ~AbstractGroupListModel();
    inline ThumbnailCache* thumbnailCache() const { return m_cache; }
    void setThumbnailCache(ThumbnailCache *cache);
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role) const;
    Q_INVOKABLE QVariant data(int row, const QByteArray &role) const;
    QSharedPointer<GroupItem> get(int row) const;
    Q_INVOKABLE GroupItem* getFromQML(int row) const;
    void insertGroup(int row, QSharedPointer<GroupItem> group);
    void appendGroup(QSharedPointer<GroupItem> group);
    bool removeGroup(const QVariant &value, int role = IdRole);

public slots:
    void clear();

protected:
    bool removeRow(int row, const QModelIndex &parent = QModelIndex());

protected slots:
    void onThumbnailReady();

protected:
    ThumbnailCache *m_cache;
    QList< QSharedPointer<GroupItem> > m_list;
};

#endif // ABSTRACTGROUPLISTMODEL_H
