#ifndef YOUTUBEUSERLISTTAB_H
#define YOUTUBEUSERLISTTAB_H

#include "abstracttab.h"

class Session;
class YouTubeUserListModel;
class ListView;
class QLabel;
class QGridLayout;
class QAction;
class QModelIndex;

class YouTubeUserListTab : public AbstractTab
{
    Q_OBJECT
public:
    explicit YouTubeUserListTab(Session *session, const QString &userId, QWidget *parent = 0);
    void setFeed(const QString &feed);
    
private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);
    void onItemClicked(const QModelIndex &index);
    void showUserChannel(const QString &userId);
    void showSubscriptionVideos();

private:
    Session *m_session;
    QString m_userId;
    YouTubeUserListModel *m_model;
    ListView *m_listView;
    QAction *m_videosAction;
    QLabel *m_noResultsLabel;
    QGridLayout *m_grid;
};

#endif // YOUTUBEUSERLISTTAB_H
