#include "youtubeauthdialog.h"
#include "../base/session.h"
#include "webview.h"
#include <QProgressBar>
#include <QGridLayout>


YouTubeAuthDialog::YouTubeAuthDialog(Session *session, const QString &accountName, QWidget *parent) :
    AbstractDialog(parent),
    m_session(session),
    m_name(accountName),
    m_webView(new WebView(this)),
    m_progressBar(new QProgressBar(this)),
    m_grid(new QGridLayout(this))
{
    this->setWindowTitle(tr("YouTube authorisation"));

    m_grid->addWidget(m_webView, 0, 0);
    m_grid->addWidget(m_progressBar, 1, 0);
    m_webView->setUrl(m_session->youtube()->authUrl());
    m_webView->enableSelectionSuppressor();
    m_progressBar->setTextVisible(false);

    this->connect(m_webView, SIGNAL(titleChanged(QString)), this, SLOT(checkTitleForCode(QString)));
    this->connect(m_webView, SIGNAL(loadProgress(int)), m_progressBar, SLOT(setValue(int)));
    this->connect(m_webView, SIGNAL(loadStarted()), m_progressBar, SLOT(show()));
    this->connect(m_webView, SIGNAL(loadFinished(bool)), m_progressBar, SLOT(hide()));

    this->onOrientationChanged();
}

void YouTubeAuthDialog::checkTitleForCode(const QString &title) {
    if (title.contains("code=")) {
        QString code = title.section("code=", 1, 1).section('&', 0, 0);
        m_session->youtube()->signIn(m_name, code);
        this->accept();
    }
    else if (title.contains("access_denied")) {
        m_session->onInfo(tr("You have denied access to your YouTube account"));
        this->reject();
    }
}
