#ifndef VIMEOVIDEOLISTTAB_H
#define VIMEOVIDEOLISTTAB_H

#include "abstracttab.h"
#include "../base/videoitem.h"

class Session;
class VimeoVideoListModel;
class ListView;
class QAction;
class QLabel;
class QGridLayout;
class QModelIndex;
class QMenu;

class VimeoVideoListTab : public AbstractTab
{
    Q_OBJECT

public:
    explicit VimeoVideoListTab(Session *session, QWidget *parent = 0);
    void setVideoFeed(const QString &feed);

protected:
    void showEvent(QShowEvent *event);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void setMenuActions();
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);
    void deleteVideosFromUploads();
    void addVideosToLikes();
    void deleteVideosFromLikes();
    void addVideosToAlbum();
    void addVideosToWatchLaterAlbum();
    void addVideoDownloads();
    void addAudioDownloads();
    void queueVideos();
    void showContextMenu(const QPoint &pos);
    void deleteVideoFromUploads();
    void addVideoToLikes();
    void deleteVideoFromLikes();
    void showAlbumDialog();
    void addVideoToAlbum(const QString &id);
    void addVideoToNewAlbum(const QVariantMap &album);
    void addVideoToWatchLaterAlbum();
    void addVideoDownload();
    void addAudioDownload();
    void queueVideo();
    void onItemClicked(const QModelIndex &index);
    void showVideoInfo(QSharedPointer<VideoItem> video);
    void playVideo(const QModelIndex &index);

private:
    Session *m_session;
    VimeoVideoListModel *m_model;
    ListView *m_listView;
    QAction *m_deleteFromUploadsAction;
    QAction *m_addToLikesAction;
    QAction *m_deleteFromLikesAction;
    QAction *m_addToAlbumAction;
    QAction *m_watchLaterAction;
    QAction *m_addToQueueAction;
    QAction *m_videoDownloadAction;
    QAction *m_audioDownloadAction;
    QMenu *m_contextMenu;
    QAction *m_deleteFromUploadsContextAction;
    QAction *m_addToLikesContextAction;
    QAction *m_deleteFromLikesContextAction;
    QAction *m_addToAlbumContextAction;
    QAction *m_watchLaterContextAction;
    QAction *m_addToQueueContextAction;
    QAction *m_videoDownloadContextAction;
    QAction *m_audioDownloadContextAction;
    QLabel *m_noResultsLabel;
    QGridLayout *m_grid;
};

#endif // VIMEOVIDEOLISTTAB_H
