#ifndef VIMEOVIDEOINFOWINDOW_H
#define VIMEOVIDEOINFOWINDOW_H

#include "stackedwindow.h"
#include "../base/videoitem.h"

class VimeoVideoDescriptionTab;
class VimeoVideoCommentsTab;
class VimeoRelatedVideosTab;
class QStackedWidget;
class QActionGroup;
class QMenu;

class VimeoVideoInfoWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit VimeoVideoInfoWindow(Session *session, QSharedPointer<VideoItem> video, QWidget *parent);

private:
    void clearMenuActions();

private slots:
    void showInfo();
    void showComments();
    void showRelatedVideos();

private:
    QSharedPointer<VideoItem> m_video;
    QMenu *m_menu;
    QActionGroup *m_actionGroup;
    QAction *m_infoAction;
    QAction *m_commentsAction;
    QAction *m_relatedAction;
    QStackedWidget *m_tabWidget;
    VimeoVideoDescriptionTab *m_infoTab;
    VimeoVideoCommentsTab *m_commentsTab;
    VimeoRelatedVideosTab *m_relatedTab;
};

#endif // VIMEOVIDEOINFOWINDOW_H
