#ifndef TRANSFERPRIORITYSELECTOR_H
#define TRANSFERPRIORITYSELECTOR_H

#include "../base/enums.h"
#include <QMaemo5ValueButton>

class TransferPriorityModel;
class QMaemo5ListPickSelector;

class TransferPrioritySelector : public QMaemo5ValueButton
{
    Q_OBJECT
public:
    explicit TransferPrioritySelector(const QString &text, QWidget *parent = 0);
    void setValue(Transfers::TransferPriority value);
    Transfers::TransferPriority currentValue();

private slots:
    void onSelected();
    
signals:
    void valueChanged(Transfers::TransferPriority value);
    
private:
    TransferPriorityModel *m_model;
    QMaemo5ListPickSelector *m_selector;
};

#endif // TRANSFERPRIORITYSELECTOR_H
