#ifndef DAILYMOTIONPROFILETAB_H
#define DAILYMOTIONPROFILETAB_H

#include "abstracttab.h"
#include "../base/useritem.h"

class Session;
class SeparatorLabel;
class AvatarLabel;
class QLabel;
class QPushButton;
class QScrollArea;
class QGridLayout;

class DailymotionProfileTab : public AbstractTab
{
    Q_OBJECT

public:
    explicit DailymotionProfileTab(Session *session, const QString &userId, QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void setUser(QSharedPointer<UserItem> user);
    void setAvatar();
    void onProfileError();
    void toggleSubscription();
    void onSubscribedChanged(bool subscribed);

private:
    Session *m_session;
    QSharedPointer<UserItem> m_user;
    AvatarLabel *m_avatar;
    QLabel *m_channelLabel;
    QLabel *m_viewsLabel;
    QLabel *m_locationLabel;
    QLabel *m_descriptionLabel;
    QLabel *m_noProfileLabel;
    QPushButton *m_subscriptionButton;
    QScrollArea *m_scrollArea;
    QGridLayout *m_grid;
};

#endif // DAILYMOTIONPROFILETAB_H
