#ifndef VIMEOUSERGROUPLISTMODEL_H
#define VIMEOUSERGROUPLISTMODEL_H

#include "groupitem.h"
#include <QAbstractListModel>
#include <QSharedPointer>

class Session;
class ThumbnailCache;

class VimeoUserGroupListModel : public QAbstractListModel
{
    Q_OBJECT

    Q_PROPERTY(Session* session
               READ session
               WRITE setSession)
    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    enum Roles {
        IdRole = Qt::UserRole + 1,
        TitleRole,
        ArtistRole,
        DateRole,
        VideoCountRole,
        ThumbnailRole,
        ThumbnailUrlRole,
        DescriptionRole
    };

public:
    explicit VimeoUserGroupListModel(Session *session = 0, QObject *parent = 0);
    ~VimeoUserGroupListModel() {}
    inline Session* session() const { return m_session; }
    void setSession(Session *session);
    inline ThumbnailCache* thumbnailCache() const { return m_cache; }
    void setThumbnailCache(ThumbnailCache *cache);
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role = Qt::DisplayRole) const;
    Q_INVOKABLE QVariant data(int row, const QByteArray &role) const;
    QSharedPointer<GroupItem> get(int row) const;
    Q_INVOKABLE GroupItem* getFromQML(int row) const;

private slots:
    void onGroupAdded(int row);
    void onGroupRemoved(int row);
    void onThumbnailReady();

signals:
    void countChanged(int count);

private:
    Session *m_session;
    ThumbnailCache *m_cache;
};

#endif // VIMEOUSERGROUPLISTMODEL_H
