#include "vimeogrouplistmodel.h"
#include "feedurls.h"
#include "session.h"
#include <QNetworkReply>
#include <QNetworkRequest>

VimeoGroupListModel::VimeoGroupListModel(Session *session, QObject *parent) :
    AbstractGroupListModel(!session ? 0 : session->newThumbnailCache(), parent),
    m_session(session),
    m_loading(true),
    m_moreResults(true),
    m_error(false),
    m_offset(1)
{
}

void VimeoGroupListModel::setSession(Session *session) {
    m_session = session;
}

void VimeoGroupListModel::clear() {
    AbstractGroupListModel::clear();
    this->setLoading(false);
    this->setOffset(1);
    this->setMoreResults(true);
    this->setError(false);
}

void VimeoGroupListModel::reset() {
    if (!this->loading()) {
        this->clear();
        this->getMoreGroups();
    }
}

void VimeoGroupListModel::setFeed(const QString &feed) {
    if (feed != this->feed()) {
        m_feed = feed;
    }
}

void VimeoGroupListModel::getGroups(const QString &feed) {
    if (!feed.isEmpty()) {
        this->setFeed(feed);
    }

    this->setLoading(true);
    QNetworkReply *reply = this->session()->vimeo()->createReply(this->feed(), this->offset());
    this->connect(reply, SIGNAL(finished()), this, SLOT(addGroups()));
}

void VimeoGroupListModel::addGroups() {
    QNetworkReply *reply = qobject_cast<QNetworkReply*>(sender());

    if (!reply) {
        this->setLoading(false);
        this->setError(true);
        return;
    }

    QDomDocument doc;
    doc.setContent(reply->readAll());
    QDomElement responseNode = doc.firstChildElement("rsp");

    if (responseNode.attribute("stat") == "ok") {
        QDomNodeList entries = doc.elementsByTagName("group");

        for (int i = 0; i < entries.size(); i++) {
            GroupItem *group = new GroupItem;
            group->loadVimeoGroup(entries.at(i).toElement());
            this->connect(this->session()->vimeo(), SIGNAL(groupMembershipChanged(QString,bool)), group, SLOT(onMembershipChanged(QString,bool)));
            this->appendGroup(QSharedPointer<GroupItem>(group));
        }

        QDomElement statNode = responseNode.firstChildElement("groups");

        this->setLoading(false);
        this->setMoreResults(statNode.attribute("total").toInt() > this->rowCount());
        this->setOffset(statNode.attribute("page").toInt() + 1);

        emit countChanged(this->rowCount());
    }
    else {
        this->setLoading(false);
        this->setError(true);
    }

    reply->deleteLater();
}

void VimeoGroupListModel::getMoreGroups() {
    if ((this->moreResults()) && (!this->loading())) {
        this->getGroups();
    }
}

GroupItem* VimeoGroupListModel::getFromQML(int row) const {
    if (GroupItem *group = AbstractGroupListModel::getFromQML(row)) {
        this->connect(this->session()->vimeo(), SIGNAL(groupMembershipChanged(QString,bool)), group, SLOT(onMembershipChanged(QString,bool)));

        return group;
    }

    return 0;
}
