#include "vimeoalbumlistmodel.h"
#include "feedurls.h"
#include "session.h"
#include <QNetworkReply>
#include <QNetworkRequest>

VimeoAlbumListModel::VimeoAlbumListModel(Session *session, QObject *parent) :
    AbstractPlaylistListModel(!session ? 0 : session->newThumbnailCache(), parent),
    m_session(session),
    m_loading(true),
    m_moreResults(true),
    m_error(false),
    m_offset(1)
{
}

void VimeoAlbumListModel::setSession(Session *session) {
    m_session = session;
}

void VimeoAlbumListModel::clear() {
    AbstractPlaylistListModel::clear();
    this->setLoading(false);
    this->setOffset(1);
    this->setMoreResults(true);
    this->setError(false);
}

void VimeoAlbumListModel::reset() {
    if (!this->loading()) {
        this->clear();
        this->getMoreAlbums();
    }
}

void VimeoAlbumListModel::setFeed(const QString &feed) {
    if (feed != this->feed()) {
        m_feed = feed;
    }
}

void VimeoAlbumListModel::getAlbums(const QString &feed) {
    if (!feed.isEmpty()) {
        this->setFeed(feed);
    }

    this->setLoading(true);
    QNetworkReply *reply = this->session()->vimeo()->createReply(this->feed(), this->offset());
    this->connect(reply, SIGNAL(finished()), this, SLOT(addAlbums()));
}

void VimeoAlbumListModel::addAlbums() {
    QNetworkReply *reply = qobject_cast<QNetworkReply*>(sender());

    if (!reply) {
        this->setLoading(false);
        this->setError(true);
        return;
    }

    QDomDocument doc;
    doc.setContent(reply->readAll());
    QDomElement responseNode = doc.firstChildElement("rsp");

    if (responseNode.attribute("stat") == "ok") {
        QDomNodeList entries = doc.elementsByTagName("album");

        for (int i = 0; i < entries.size(); i++) {
            PlaylistItem *playlist = new PlaylistItem;
            playlist->loadVimeoAlbum(entries.at(i).toElement());
            this->appendPlaylist(QSharedPointer<PlaylistItem>(playlist));
        }

        QDomElement statNode = responseNode.firstChildElement("albums");

        this->setLoading(false);
        this->setMoreResults(statNode.attribute("total").toInt() > this->rowCount());
        this->setOffset(statNode.attribute("page").toInt() + 1);

        emit countChanged(this->rowCount());
    }
    else {
        this->setLoading(false);
        this->setError(true);
    }

    reply->deleteLater();
}

void VimeoAlbumListModel::getMoreAlbums() {
    if ((this->moreResults()) && (!this->loading())) {
        this->getAlbums();
    }
}
