#ifndef THUMBNAILDOWNLOADER_H
#define THUMBNAILDOWNLOADER_H

#include <QObject>
#include <QNetworkReply>
#include <QUrl>

class QNetworkAccessManager;
class QImage;

class ThumbnailDownloader : public QObject
{
    Q_OBJECT
public:
    explicit ThumbnailDownloader(QObject *parent = 0);
    inline QNetworkAccessManager* networkAccessManager() const { return m_nam; }
    inline void setNetworkAccessManager(QNetworkAccessManager *manager) { m_nam = manager; }

public slots:
    void downloadThumbnail(const QUrl &url);

private slots:
    void onThumbnailDownloaded();

signals:
    void gotThumbnail(QNetworkReply* reply);
    
private:
    QNetworkAccessManager *m_nam;
};

#endif // THUMBNAILDOWNLOADER_H
