#include "playlistitem.h"
#include "utils.h"

PlaylistItem::PlaylistItem(QObject *parent) :
    QObject(parent),
    m_duration(0),
    m_videoCount(0)
{
}

PlaylistItem::PlaylistItem(PlaylistItem *playlist, QObject *parent) :
    QObject(parent),
    m_id(playlist->id()),
    m_playlistId(playlist->playlistId()),
    m_title(playlist->title()),
    m_artist(playlist->artist()),
    m_artistId(playlist->artistId()),
    m_artistAvatarUrl(playlist->artistAvatarUrl()),
    m_description(playlist->description()),
    m_duration(playlist->duration()),
    m_date(playlist->date()),
    m_thumbnailUrl(playlist->thumbnailUrl()),
    m_videoCount(playlist->videoCount())
{
}

void PlaylistItem::loadDailymotionPlaylist(const QVariantMap &playlist) {
    this->setId(playlist.value("id").toString());
    this->setPlaylistId(this->id());
    this->setTitle(playlist.value("name").toString());
    this->setArtist(playlist.value("owner.username").toString());
    this->setArtistId(playlist.value("owner.id").toString());
    this->setArtistAvatarUrl(playlist.value("owner.avatar_medium_url").toUrl());
    this->setDescription(playlist.value("description").toString());
    this->setDate(Utils::dateFromSecs(playlist.value("created_time").toLongLong()));
}

void PlaylistItem::loadYouTubePlaylist(const QDomNode &playlist) {
    this->setId(playlist.firstChildElement("id").text());
    this->setPlaylistId(playlist.firstChildElement("yt:playlistId").text());
    this->setTitle(playlist.firstChildElement("title").text());
    this->setArtist(playlist.firstChildElement("author").firstChildElement("name").text());
    this->setArtistId(playlist.firstChildElement("author").firstChildElement("yt:userId").text());
    this->setArtistAvatarUrl(QUrl(QString("http://i2.ytimg.com/i/%1/1.jpg").arg(this->artistId())));
    this->setDescription(playlist.firstChildElement("summary").text());
    this->setDate(Utils::localDateTimeFromString(playlist.firstChildElement("published").text()));
    this->setThumbnailUrl(QUrl(playlist.firstChildElement("media:group").firstChildElement("media:thumbnail").attribute("url")));
    this->setVideoCount(playlist.firstChildElement("yt:countHint").text().toInt());
}

void PlaylistItem::loadVimeoAlbum(const QDomElement &album) {
    this->setId(album.attribute("id"));
    this->setPlaylistId(this->id());
    this->setTitle(album.firstChildElement("title").text());
    this->setDescription(album.firstChildElement("description").text());
    this->setDate(Utils::localDateTimeFromString(album.firstChildElement("created_on").text()));
    this->setVideoCount(album.firstChildElement("total_videos").text().toInt());

    QDomNodeList thumbnails = album.firstChildElement("thumbnail_video").firstChildElement("thumbnails").childNodes();

    if (thumbnails.size() > 1) {
        this->setThumbnailUrl(QUrl(thumbnails.at(1).toElement().text()));
    }
}
