#include "dailymotionusergrouplistmodel.h"
#include "session.h"
#ifdef QML_USER_INTERFACE
#include <QDeclarativeEngine>
#endif

DailymotionUserGroupListModel::DailymotionUserGroupListModel(Session *session, QObject *parent) :
    QAbstractListModel(parent),
    m_session(session)
{
    QHash<int, QByteArray> roles;
    roles[IdRole] = "id";
    roles[TitleRole] = "title";
    roles[ArtistRole] = "artist";
    roles[DateRole] = "date";
    roles[DescriptionRole] = "description";
    this->setRoleNames(roles);

    if (this->session()) {
        if (!this->session()->dailymotion()->groupsLoaded()) {
            this->session()->dailymotion()->getGroups();
        }

        this->connect(this->session()->dailymotion(), SIGNAL(groupAddedToCache(int)), this, SLOT(onGroupAdded(int)));
        this->connect(this->session()->dailymotion(), SIGNAL(groupRemovedFromCache(int)), this, SLOT(onGroupRemoved(int)));
    }
}

void DailymotionUserGroupListModel::setSession(Session *session) {
    m_session = session;

    if (this->session()) {
        if (!this->session()->dailymotion()->groupsLoaded()) {
            this->session()->dailymotion()->getGroups();
        }

        this->connect(this->session()->dailymotion(), SIGNAL(groupAddedToCache(int)), this, SLOT(onGroupAdded(int)));
        this->connect(this->session()->dailymotion(), SIGNAL(groupRemovedFromCache(int)), this, SLOT(onGroupRemoved(int)));
    }
}

void DailymotionUserGroupListModel::onGroupAdded(int row) {
    this->beginInsertRows(QModelIndex(), row, row);
    this->endInsertRows();
    emit countChanged(this->rowCount());
}

void DailymotionUserGroupListModel::onGroupRemoved(int row) {
    this->beginRemoveRows(QModelIndex(), row, row);
    this->endRemoveRows();
    emit countChanged(this->rowCount());
}

int DailymotionUserGroupListModel::rowCount(const QModelIndex &parent) const {
    Q_UNUSED(parent)

    return !this->session() ? 0 : this->session()->dailymotion()->groups()->size();
}

QVariant DailymotionUserGroupListModel::data(const QModelIndex &index, int role) const {
    switch (role) {
    case IdRole:
        return this->session()->dailymotion()->groups()->at(index.row()).data()->id();
    case TitleRole:
        return this->session()->dailymotion()->groups()->at(index.row()).data()->title();
    case ArtistRole:
        return this->session()->dailymotion()->groups()->at(index.row()).data()->artist();
    case DateRole:
        return this->session()->dailymotion()->groups()->at(index.row()).data()->date();
    case DescriptionRole:
        return this->session()->dailymotion()->groups()->at(index.row()).data()->description();
    default:
        return QVariant();
    }
}

QVariant DailymotionUserGroupListModel::data(int row, const QByteArray &role) const {
    return this->data(this->index(row), this->roleNames().key(role));
}

QSharedPointer<GroupItem> DailymotionUserGroupListModel::get(int row) const {
    return QSharedPointer<GroupItem>(this->session()->dailymotion()->groups()->at(row));
}

GroupItem* DailymotionUserGroupListModel::getFromQML(int row) const {
#ifdef QML_USER_INTERFACE
    GroupItem *group = new GroupItem(this->session()->dailymotion()->groups()->at(row).data());
    this->connect(this->session()->dailymotion(), SIGNAL(groupMembershipChanged(QString,bool)), group, SLOT(onMembershipChanged(QString,bool)));
    QDeclarativeEngine::setObjectOwnership(group, QDeclarativeEngine::JavaScriptOwnership);

    return group;
#else
    Q_UNUSED(row)
#endif
    return 0;
}
