#include "dailymotionaccountslistmodel.h"
#include "session.h"
#include <QSqlRecord>
#include <QSqlField>

DailymotionAccountsListModel::DailymotionAccountsListModel(Session *session, QObject *parent) :
    QSqlTableModel(parent, QSqlDatabase::database()),
    m_session(session)
{
    QHash<int, QByteArray> roles;
    roles[DisplayNameRole] = "displayName";
    roles[UsernameRole] = "username";
    roles[AccessTokenRole] = "accessToken";
    roles[RefreshTokenRole] = "refreshToken";
    roles[CookiesRole] = "cookies";
    roles[ActiveRole] = "active";
    this->setRoleNames(roles);
    this->setTable("dailymotionAccounts");
    this->setEditStrategy(QSqlTableModel::OnManualSubmit);
    this->select();

    if (this->session()) {
        this->connect(this->session()->dailymotion(), SIGNAL(signedIn(QString,QString,QString)), this, SLOT(addAccount(QString,QString,QString)));
        this->connect(this, SIGNAL(accountSelected(QString,QString,QString)), this->session()->dailymotion(), SLOT(setAccount(QString,QString,QString)));
        this->connect(this, SIGNAL(accountAdded(QString,QString,QString)), this->session()->dailymotion(), SLOT(setAccount(QString,QString,QString)));
        this->connect(this, SIGNAL(accountDeleted()), this->session()->dailymotion(), SLOT(signOut()));
        this->connect(this, SIGNAL(gotCookies(QByteArray)), this->session()->cookieJar(), SLOT(setDailymotionCookies(QByteArray)));
        this->connect(this, SIGNAL(accountAdded(QString,QString,QString)), this->session()->cookieJar(), SLOT(clearDailymotionCookies()));
        this->connect(this, SIGNAL(accountDeleted()), this->session()->cookieJar(), SLOT(clearDailymotionCookiesFromDB()));
        this->connect(this, SIGNAL(error(QString)), this->session(), SLOT(onError(QString)));
    }
}

DailymotionAccountsListModel::~DailymotionAccountsListModel() {
    this->clear();
}

void DailymotionAccountsListModel::setSession(Session *session) {
    m_session = session;

    if (this->session()) {
        this->connect(this->session()->dailymotion(), SIGNAL(signedIn(QString,QString,QString)), this, SLOT(addAccount(QString,QString,QString)));
        this->connect(this, SIGNAL(accountSelected(QString,QString,QString)), this->session()->dailymotion(), SLOT(setAccount(QString,QString,QString)));
        this->connect(this, SIGNAL(accountAdded(QString,QString,QString)), this->session()->dailymotion(), SLOT(setAccount(QString,QString,QString)));
        this->connect(this, SIGNAL(accountDeleted()), this->session()->dailymotion(), SLOT(signOut()));
        this->connect(this, SIGNAL(gotCookies(QByteArray)), this->session()->cookieJar(), SLOT(setDailymotionCookies(QByteArray)));
        this->connect(this, SIGNAL(accountAdded(QString,QString,QString)), this->session()->cookieJar(), SLOT(clearDailymotionCookies()));
        this->connect(this, SIGNAL(accountDeleted()), this->session()->cookieJar(), SLOT(clearDailymotionCookiesFromDB()));
        this->connect(this, SIGNAL(error(QString)), this->session(), SLOT(onError(QString)));
    }
}

void DailymotionAccountsListModel::setActiveAccount(int row) {
    this->database().open();
    QSqlField nameField("name", QVariant::String);
    QSqlField usernameField("username", QVariant::String);
    QSqlField tokenField("token", QVariant::String);
    QSqlField refreshField("refresh", QVariant::String);
    QSqlField cookiesField("cookies", QVariant::ByteArray);
    QSqlField activeField("active", QVariant::Int);
    nameField.setValue(this->data(this->index(row, 0), DisplayNameRole));
    usernameField.setValue(this->data(this->index(row, 0), UsernameRole));
    tokenField.setValue(this->data(this->index(row, 0), AccessTokenRole));
    refreshField.setValue(this->data(this->index(row, 0), RefreshTokenRole));
    cookiesField.setValue(this->data(this->index(row, 0), CookiesRole));
    activeField.setValue(1);

    QSqlRecord rec;
    rec.append(nameField);
    rec.append(usernameField);
    rec.append(tokenField);
    rec.append(refreshField);
    rec.append(cookiesField);
    rec.append(activeField);

    this->setRecord(row, rec);

    for (int i = 0; i < this->rowCount(); i++) {
        if (i != row) {
            nameField.setValue(this->data(this->index(i, 0), DisplayNameRole));
            usernameField.setValue(this->data(this->index(i, 0), UsernameRole));
            tokenField.setValue(this->data(this->index(i, 0), AccessTokenRole));
            refreshField.setValue(this->data(this->index(i, 0), RefreshTokenRole));
            cookiesField.setValue(this->data(this->index(i, 0), CookiesRole));
            activeField.setValue(0);

            rec.clear();
            rec.append(nameField);
            rec.append(usernameField);
            rec.append(tokenField);
            rec.append(refreshField);
            rec.append(cookiesField);
            rec.append(activeField);

            this->setRecord(i, rec);
        }
    }

    this->submitAll();
}

void DailymotionAccountsListModel::switchAccount(int row) {
    this->setActiveAccount(row);

    this->database().open();
    QString user = this->data(this->index(row, 0), UsernameRole).toString();
    QString token = this->data(this->index(row, 0), AccessTokenRole).toString();
    QString refresh = this->data(this->index(row, 0), RefreshTokenRole).toString();
    QByteArray cookieString = this->data(this->index(row, 0), CookiesRole).toByteArray();

    emit accountSelected(user, token, refresh);
    emit gotCookies(cookieString);
}

QVariant DailymotionAccountsListModel::data(const QModelIndex &idx, int role) const {
    return QSqlTableModel::data(this->index(idx.row(), role - Qt::DisplayRole));
}

QVariant DailymotionAccountsListModel::data(int row, const QByteArray &role) const {
    return this->data(this->index(row, 0), this->roleNames().key(role));
}

void DailymotionAccountsListModel::addAccount(const QString &displayName, const QString &token, const QString &refresh) {
    this->database().open();
    QSqlField nameField("name", QVariant::String);
    QSqlField usernameField("username", QVariant::String);
    QSqlField tokenField("token", QVariant::String);
    QSqlField refreshField("refresh", QVariant::String);
    QSqlField cookiesField("cookies", QVariant::ByteArray);
    QSqlField activeField("active", QVariant::Int);
    nameField.setValue(displayName);
    usernameField.setValue(QVariant::String);
    tokenField.setValue(token);
    refreshField.setValue(refresh);
    cookiesField.setValue(QVariant::ByteArray);
    activeField.setValue(0);

    QSqlRecord rec;
    rec.append(nameField);
    rec.append(usernameField);
    rec.append(tokenField);
    rec.append(refreshField);
    rec.append(cookiesField);
    rec.append(activeField);

    this->insertRecord(-1, rec);
    this->submitAll();
    this->setActiveAccount(this->rowCount() - 1);

    emit accountAdded(QString(), token, refresh);
    emit countChanged(this->rowCount());
}

void DailymotionAccountsListModel::deleteAccount(int row) {
    this->database().open();
    bool signOut = this->data(this->index(row, 0), ActiveRole).toBool();

    if ((this->removeRow(row)) && (this->submitAll())) {
        if (signOut) {
            emit accountDeleted();
        }

        emit countChanged(this->rowCount());
    }
    else {
        emit error(tr("Database error. Unable to delete account"));
    }
}
