#ifndef ABSTRACTVIDEOLISTMODEL_H
#define ABSTRACTVIDEOLISTMODEL_H

#include "videoitem.h"
#include <QAbstractListModel>
#include <QSharedPointer>

class ThumbnailCache;

class AbstractVideoListModel : public QAbstractListModel
{
    Q_OBJECT

public:
    enum Roles {
        IdRole = Qt::UserRole + 1,
        VideoIdRole,
        FavouriteIdRole,
        PlaylistVideoIdRole,
        TitleRole,
        ArtistRole,
        DateRole,
        DurationRole,
        ViewCountRole,
        LikesRole,
        DislikesRole,
        RatingCountRole,
        RatingRole,
        ThumbnailRole,
        ThumbnailUrlRole,
        ArchiveRole,
        ServiceRole,
        FavouriteRole,
        SelectedRole,
        ThumbnailPressedRole
    };

public:
    explicit AbstractVideoListModel(ThumbnailCache *cache = 0, QObject *parent = 0);
    ~AbstractVideoListModel();
    inline ThumbnailCache* thumbnailCache() const { return m_cache; }
    void setThumbnailCache(ThumbnailCache *cache);
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role) const;
    Q_INVOKABLE QVariant data(int row, const QByteArray &role) const;
    bool setData(const QModelIndex &index, const QVariant &value, int role);
    QSharedPointer<VideoItem> get(int row) const;
    Q_INVOKABLE VideoItem* getFromQML(int row) const;
    Q_INVOKABLE QList<int> selectedRows() const { return m_selectedRows; }
    QList< QSharedPointer<VideoItem> > selectedItems() const;
    Q_INVOKABLE QList<VideoItem*> selectedItemsFromQML() const;
    inline bool itemsSelected() const { return !this->selectedRows().isEmpty(); }
    void insertVideo(int row, QSharedPointer<VideoItem> video);
    void appendVideo(QSharedPointer<VideoItem> video);
    bool removeVideo(const QVariant &value, int role = VideoIdRole);

public slots:
    void clear();
    void selectAll();
    void selectNone();
    void toggleSelected(int row);

protected:
    bool removeRow(int row, const QModelIndex &parent = QModelIndex());

protected slots:
    void onThumbnailReady();
    
protected:
    ThumbnailCache *m_cache;
    QList< QSharedPointer<VideoItem> > m_list;
    QList<int> m_selectedRows;
    int m_thumbnailPressedRow;
};

#endif // ABSTRACTVIDEOLISTMODEL_H
