#ifndef YOUTUBEMYCHANNELWINDOW_H
#define YOUTUBEMYCHANNELWINDOW_H

#include "stackedwindow.h"
#include "youtubeprofiletab.h"
#include "youtubevideolisttab.h"
#include "youtubeuserplaylistlisttab.h"
#include "youtubesubscriptionstab.h"
#include <QStackedWidget>
#include <QActionGroup>
#include <QMenu>

class YouTubeMyChannelWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit YouTubeMyChannelWindow(Session *session, QWidget *parent);

private:
    void clearMenuActions();

private slots:
    void showProfile();
    void showUploads();
    void showFavourites();
    void showRecommended();
    void showPlaylists();
    void showSubscriptions();
    
private:
    QMenu *m_menu;
    QActionGroup *m_actionGroup;
    QAction *m_profileAction;
    QAction *m_uploadsAction;
    QAction *m_favouritesAction;
    QAction *m_recommendedAction;
    QAction *m_playlistsAction;
    QAction *m_subscriptionsAction;
    QStackedWidget *m_tabWidget;
    YouTubeProfileTab *m_profileTab;
    YouTubeVideoListTab *m_uploadsTab;
    YouTubeVideoListTab *m_favouritesTab;
    YouTubeVideoListTab *m_recommendedTab;
    YouTubeUserPlaylistListTab *m_playlistsTab;
    YouTubeSubscriptionsTab *m_subscriptionsTab;
};

#endif // YOUTUBEMYCHANNELWINDOW_H
