#include "useritem.h"

UserItem::UserItem(const QVariantMap &user, bool subscribed, QObject *parent) :
    QObject(parent),
    m_id(user.value("id").toString()),
    m_username(user.value("username").toString()),
    m_channelName(user.value("screenname").toString()),
    m_description(user.value("description").toString()),
    m_avatarUrl(user.value("avatar_medium_url").toString()),
    m_videoCount(user.value("videos_total").toInt()),
    m_viewCount(user.value("views_total").toInt()),
    m_subscriberCount(0),
    m_subscribed(subscribed),
    m_subscriptionId(id()),
    m_accountLinked(true)
{
}

UserItem::UserItem(const QDomNode &user, bool subscription, bool subscribed, QObject *parent) :
    QObject(parent),
    m_id(subscription ? user.firstChildElement("yt:channelId").text().section("UC", 1) : user.firstChildElement("author").firstChildElement("yt:userId").text()),
    m_username(subscription ? user.firstChildElement("yt:username").attribute("display") : user.firstChildElement("author").firstChildElement("name").text()),
    m_channelName(user.firstChildElement("title").text()),
    m_description(user.firstChildElement("summary").text()),
    m_avatarUrl(subscription ? user.firstChildElement("media:thumbnail").attribute("url") : "http://i2.ytimg.com/i/" + id() + "/1.jpg"),
    m_videoCount(subscription ? user.firstChildElement("yt:countHint").text().toInt() : user.firstChildElement("gd:feedLink").attribute("countHint").toInt()),
    m_viewCount(user.firstChildElement("yt:channelStatistics").attribute("viewCount").toInt()),
    m_subscriberCount(user.firstChildElement("yt:channelStatistics").attribute("subscriberCount").toInt()),
    m_subscription(subscription),
    m_subscribed(subscribed),
    m_subscriptionId(user.firstChildElement("id").text().section(':', -1)),
    m_accountLinked(true)
{
}
