#include "twitterauthdialog.h"

TwitterAuthDialog::TwitterAuthDialog(Session *session, QWidget *parent) :
    AbstractDialog(parent),
    m_session(session),
    m_webView(new WebView(this)),
    m_progressBar(new QProgressBar(this)),
    m_grid(new QGridLayout(this))
{
    setWindowTitle(tr("twitter authorisation"));

    m_grid->addWidget(m_webView, 0, 0);
    m_grid->addWidget(m_progressBar, 1, 0);

    m_webView->enableSelectionSuppressor();
    m_progressBar->setTextVisible(false);

    connect(m_session->sharing(), SIGNAL(gotTwitterAuthUrl(QUrl)), this, SLOT(setAuthUrl(QUrl)));
    connect(m_webView, SIGNAL(loadProgress(int)), m_progressBar, SLOT(setValue(int)));
    connect(m_webView, SIGNAL(loadStarted()), m_progressBar, SLOT(show()));
    connect(m_webView, SIGNAL(loadFinished(bool)), m_progressBar, SLOT(hide()));

    m_session->sharing()->getTwitterAuthUrl();

    onOrientationChanged();
}

void TwitterAuthDialog::setAuthUrl(const QUrl &url) {
    m_webView->setUrl(url);
    connect(m_webView, SIGNAL(urlChanged(QUrl)), this, SLOT(checkUrlForToken(QUrl)));
}

void TwitterAuthDialog::checkUrlForToken(const QUrl &url) {
    if (url.toString().startsWith("https://sites.google.com/site/marxodian/home/cutetube")) {
        m_session->sharing()->signInToTwitter(url);
        accept();
    }
}
