#ifndef DAILYMOTIONVIDEOINFOWINDOW_H
#define DAILYMOTIONVIDEOINFOWINDOW_H

#include "stackedwindow.h"
#include "dailymotionvideodescriptiontab.h"
#include "dailymotionvideocommentstab.h"
#include "dailymotionrelatedvideostab.h"
#include <QStackedWidget>
#include <QActionGroup>
#include <QMenu>

class DailymotionVideoInfoWindow : public StackedWindow
{
    Q_OBJECT
public:
    explicit DailymotionVideoInfoWindow(Session *session, QSharedPointer<VideoItem> video, QWidget *parent);

private:
    void clearMenuActions();

private slots:
    void showInfo();
    void showComments();
    void showRelatedVideos();

private:
    QSharedPointer<VideoItem> m_video;
    QMenu *m_menu;
    QActionGroup *m_actionGroup;
    QAction *m_infoAction;
    QAction *m_commentsAction;
    QAction *m_relatedAction;
    QStackedWidget *m_tabWidget;
    DailymotionVideoDescriptionTab *m_infoTab;
    DailymotionVideoCommentsTab *m_commentsTab;
    DailymotionRelatedVideosTab *m_relatedTab;
};

#endif // DAILYMOTIONVIDEOINFOWINDOW_H
