#include "dailymotionplaylistdelegate.h"
#include "abstractplaylistlistmodel.h"
#include <QApplication>
#include <QStaticText>

DailymotionPlaylistDelegate::DailymotionPlaylistDelegate(QListView *parent) :
    QStyledItemDelegate(parent),
    m_view(parent)
{
}

void DailymotionPlaylistDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    if ((option.state) & (QStyle::State_Selected)) {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundPressed.png"));
    }
    else {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundNormal.png"));
    }

    QRect titleRect = option.rect;
    titleRect.setLeft(titleRect.left() + 5);
    titleRect.setRight(titleRect.right() - 5);
    titleRect.setTop(titleRect.top() + 5);
    titleRect.setHeight(60);

    painter->drawText(titleRect, Qt::TextWordWrap, index.data(AbstractPlaylistListModel::TitleRole).toString());

    QRect infoRect = option.rect;
    infoRect.setLeft(titleRect.left());
    infoRect.setRight(titleRect.right());
    infoRect.setTop(infoRect.bottom() - 75);
    infoRect.setBottom(infoRect.bottom() - 5);

    QFont oldFont = painter->font();
    QFont smallFont;
    smallFont.setPixelSize(18);
    painter->setFont(smallFont);
    QPen oldPen = painter->pen();
    painter->setPen(QColor("#4d4d4d"));

    QString description = index.data(AbstractPlaylistListModel::DescriptionRole).toString();

    QStaticText descriptionText(description.isEmpty() ? tr("No description") : description);
    descriptionText.setTextWidth(infoRect.width());

    int descriptionHeight = descriptionText.size().height();

    if (descriptionHeight <= infoRect.height()) {
        descriptionText.setTextOption(QTextOption(Qt::AlignBottom));
        infoRect.setTop(infoRect.bottom() - descriptionHeight);
    }

    painter->setClipRect(infoRect);
    painter->drawStaticText(infoRect.topLeft(), descriptionText);

    painter->setClipping(false);
    painter->setFont(oldFont);
    painter->setPen(oldPen);
}

QSize DailymotionPlaylistDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(option);
    Q_UNUSED(index);

    return QSize(m_view->width(), 150);
}
