#ifndef VIMEOVIDEOLISTWINDOW_H
#define VIMEOVIDEOLISTWINDOW_H

#include "stackedwindow.h"
#include "vimeovideolistmodel.h"
#include "listview.h"
#include <QAction>
#include <QLabel>

class VimeoVideoListWindow : public StackedWindow
{
    Q_OBJECT
public:
    explicit VimeoVideoListWindow(Session *session, QWidget *parent);
    void search(const QString &query, Queries::QueryOrder order);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onLoadingChanged();
    void addVideoDownloads();
    void addAudioDownloads();
    void queueVideos();
    void showContextMenu(const QPoint &pos);
    void addVideoDownload();
    void addAudioDownload();
    void queueVideo();
    void onItemClicked(const QModelIndex &index);
    void showVideoInfo(QSharedPointer<VideoItem> video);
    void playVideo(const QModelIndex &index);

private:
    ListView *m_listView;
    VimeoVideoListModel *m_model;
    QAction *m_addToQueueAction;
    QAction *m_videoDownloadAction;
    QAction *m_audioDownloadAction;
    QMenu *m_contextMenu;
    QAction *m_addToQueueContextAction;
    QAction *m_videoDownloadContextAction;
    QAction *m_audioDownloadContextAction;
    QLabel *m_noResultsLabel;
};

#endif // VIMEOVIDEOLISTWINDOW_H
