#include "videoplayerbutton.h"
#include <QPainter>

VideoPlayerButton::VideoPlayerButton(Role buttonRole, QWidget *parent) :
    QAbstractButton(parent),
    m_role(buttonRole)
{
    setAttribute(Qt::WA_TranslucentBackground, true);
    setStyleSheet("background:transparent");

    setFixedSize(70, 70);
}

void VideoPlayerButton::paintEvent(QPaintEvent *event) {
    Q_UNUSED(event);

    QPainter painter(this);

    switch (m_role) {
    case Previous:
        painter.drawImage(rect(), isDown() ? QImage("/etc/hildon/theme/mediaplayer/BackPressed.png") : QImage("/etc/hildon/theme/mediaplayer/Back.png"));
        break;
    case Next:
        painter.drawImage(rect(), isDown() ? QImage("/etc/hildon/theme/mediaplayer/ForwardPressed.png") : QImage("/etc/hildon/theme/mediaplayer/Forward.png"));
        break;
    default:
        icon().paint(&painter, rect());
        break;
    }
}
