#ifndef PLAYBACKQUEUEWINDOW_H
#define PLAYBACKQUEUEWINDOW_H

#include "stackedwindow.h"
#include "listview.h"
#include <QAction>
#include <QLabel>

class PlaybackQueueWindow : public StackedWindow
{
    Q_OBJECT
public:
    explicit PlaybackQueueWindow(Session *session, QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();
    void showYouTubeVideoInfo(QSharedPointer<VideoItem> video);
    void showDailymotionVideoInfo(QSharedPointer<VideoItem> video);
    void showVimeoVideoInfo(QSharedPointer<VideoItem> video);

private slots:
    void onCountChanged();
    void removeVideos();
    void addVideoDownloads();
    void addAudioDownloads();
    void showContextMenu(const QPoint &pos);
    void removeVideo();
    void addVideoDownload();
    void addAudioDownload();
    void onItemClicked(const QModelIndex &index);
    void playVideo(const QModelIndex &index);
    void playAllVideos();
    
private:
    ListView *m_listView;
    QAction *m_playAction;
    QAction *m_removeAction;
    QAction *m_videoDownloadAction;
    QAction *m_audioDownloadAction;
    QMenu *m_contextMenu;
    QAction *m_removeContextAction;
    QAction *m_videoDownloadContextAction;
    QAction *m_audioDownloadContextAction;
    QLabel *m_noResultsLabel;
};

#endif // PLAYBACKQUEUEWINDOW_H
