#ifndef NEWPLAYLIST_H
#define NEWPLAYLIST_H

#include <QString>

class NewPlaylist
{

public:
    inline explicit NewPlaylist() {}
    inline explicit NewPlaylist(const QString &title, const QString &description, bool isPrivate = false) :
        m_title(title),
        m_description(description),
        m_private(isPrivate)
    {
    }

    inline bool isEmpty() const { return m_title.isEmpty(); }
    inline QString title() const { return m_title; }
    inline void setTitle(const QString &title) { m_title = title; }
    inline QString description() const { return m_description; }
    inline void setDescription(const QString &description) { m_description = description; }
    inline bool isPrivate() const { return m_private; }
    inline void setPrivate(bool isPrivate) { m_private = isPrivate; }

private:
    QString m_title;
    QString m_description;
    bool m_private;
};

#endif // NEWPLAYLIST_H
