#include "dailymotionvideocommentstab.h"
#include "commentdelegate.h"
#include "dailymotioncommentdialog.h"
#include "dailymotionchannelwindow.h"

DailymotionVideoCommentsTab::DailymotionVideoCommentsTab(Session *session, QSharedPointer<VideoItem> video, QWidget *parent) :
    AbstractTab(parent),
    m_session(session),
    m_video(video),
    m_model(new DailymotionCommentListModel(m_session, this)),
    m_listView(new ListView(this)),
    m_commentAction(new QAction(tr("Add comment"), this)),
    m_noResultsLabel(new QLabel(QString("<p style='color:#4d4d4d;font-size:40px;'><center><b>%1</b></center></p>").arg(tr("No comments found")), this)),
    m_grid(new QGridLayout(this))
{
    addAction(m_commentAction);

    m_commentAction->setEnabled(m_session->dailymotion()->userSignedIn());
    m_noResultsLabel->hide();
    m_grid->setContentsMargins(0, 0, 0, 0);
    m_grid->addWidget(m_listView, 0, 0);

    CommentDelegate *delegate = new CommentDelegate(m_listView);

    m_listView->setModel(m_model);
    m_listView->setItemDelegate(delegate);
    m_listView->setUniformItemSizes(false);

    connect(m_model, SIGNAL(loadingChanged()), this, SLOT(onLoadingChanged()));
    connect(m_listView, SIGNAL(atEnd()), m_model, SLOT(getMoreComments()));
    connect(delegate, SIGNAL(showUserChannel(QModelIndex)), this, SLOT(showUserChannel(QModelIndex)));
    connect(m_commentAction, SIGNAL(triggered()), this, SLOT(showCommentDialog()));

    m_model->getComments(m_video.data()->videoId());

    onOrientationChanged();
}

void DailymotionVideoCommentsTab::setLandscapeLayout() {
    m_noResultsLabel->setFixedSize(800, 400);
}

void DailymotionVideoCommentsTab::setPortraitLayout() {
    m_noResultsLabel->setFixedSize(480, 700);
}

void DailymotionVideoCommentsTab::onLoadingChanged() {
    m_session->toggleBusy(m_model->loading());
    m_noResultsLabel->setVisible((!m_model->loading()) && (m_model->rowCount() == 0));
}

void DailymotionVideoCommentsTab::showCommentDialog() {
    DailymotionCommentDialog *dialog = new DailymotionCommentDialog(m_session, m_video, this);
    dialog->open();
}

void DailymotionVideoCommentsTab::showUserChannel(const QModelIndex &index) {
    DailymotionChannelWindow *window = new DailymotionChannelWindow(m_session, index.data(AbstractCommentListModel::ArtistIdRole).toString(), m_session->currentWindow());
    window->show();
}
