#include "dailymotionuserlisttab.h"
#include "dailymotionuserlistdelegate.h"
#include "dailymotionvideolistwindow.h"
#include "dailymotionchannelwindow.h"

DailymotionUserListTab::DailymotionUserListTab(Session *session, const QString &userId, QWidget *parent) :
    AbstractTab(parent),
    m_session(session),
    m_userId(userId),
    m_model(new DailymotionUserListModel(m_session, this)),
    m_listView(new ListView(this)),
    m_videosAction(new QAction(tr("Latest videos"), this)),
    m_noResultsLabel(new QLabel(QString("<p style='color:#4d4d4d;font-size:40px;'><center><b>%1</b></center></p>").arg(tr("No subscriptions found")), this)),
    m_grid(new QGridLayout(this))
{
    addAction(m_videosAction);

    m_grid->setContentsMargins(0, 0, 0, 0);
    m_grid->addWidget(m_listView, 0, 0);
    m_listView->setModel(m_model);
    m_listView->setItemDelegate(new DailymotionUserListDelegate(m_listView));
    m_noResultsLabel->hide();

    connect(m_model, SIGNAL(loadingChanged()), this, SLOT(onLoadingChanged()));
    connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    connect(m_listView, SIGNAL(atEnd()), m_model, SLOT(getMoreUsers()));
    connect(m_videosAction, SIGNAL(triggered()), this, SLOT(showSubscriptionVideos()));

    onOrientationChanged();
}

void DailymotionUserListTab::setFeed(const QString &feed) {
    m_model->getUsers(feed);
}

void DailymotionUserListTab::setLandscapeLayout() {
    m_noResultsLabel->setFixedSize(800, 400);
}

void DailymotionUserListTab::setPortraitLayout() {
    m_noResultsLabel->setFixedSize(480, 700);
}

void DailymotionUserListTab::onLoadingChanged() {
    m_session->toggleBusy(m_model->loading());
    m_noResultsLabel->setVisible((!m_model->loading()) && (m_model->rowCount() == 0));
}

void DailymotionUserListTab::onItemClicked(const QModelIndex &index) {
    if (index.isValid()) {
        showUserChannel(index.data(AbstractUserListModel::IdRole).toString());
    }
}

void DailymotionUserListTab::showUserChannel(const QString &userId) {
    DailymotionChannelWindow *window = new DailymotionChannelWindow(m_session, userId, m_session->currentWindow());
    window->show();
}

void DailymotionUserListTab::showSubscriptionVideos() {
    DailymotionVideoListWindow *window = new DailymotionVideoListWindow(m_session, m_session->currentWindow());
    window->setVideoFeed(QString("https://api.dailymotion.com/users/%1/subscriptions?limit=30").arg(m_userId));
}
