#ifndef DAILYMOTIONSUBSCRIPTIONLISTMODEL_H
#define DAILYMOTIONSUBSCRIPTIONLISTMODEL_H

#include "session.h"
#include <QAbstractListModel>

class DailymotionSubscriptionListModel : public QAbstractListModel
{
    Q_OBJECT

public:
    enum Roles {

        IdRole = Qt::UserRole+1,
        SubscriptionIdRole,
        UsernameRole,
        ChannelNameRole,
        AvatarRole,
        VideoCountRole,
        DescriptionRole,
        ViewCountRole,
        SubscriberCountRole,
        SubscriptionRole
    };

public:
    explicit DailymotionSubscriptionListModel(Session *session, QObject *parent = 0);
    ~DailymotionSubscriptionListModel();
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role = Qt::DisplayRole) const;
    inline QSharedPointer<UserItem> get(int row) const { return m_session->dailymotion()->subscriptions()->at(row); }

private slots:
    void onSubscriptionAdded(int row);
    void onSubscriptionRemoved(int row);
    void onThumbnailReady();

signals:
    void selectedRowChanged();

private:
    Session *m_session;
    ThumbnailCache *m_cache;
};

#endif // DAILYMOTIONSUBSCRIPTIONLISTMODEL_H
