#ifndef DAILYMOTIONPLAYLISTDIALOG_H
#define DAILYMOTIONPLAYLISTDIALOG_H

#include "abstractdialog.h"
#include "dailymotionuserplaylistlistmodel.h"
#include "listview.h"
#include <QDialogButtonBox>
#include <QPushButton>
#include <QLabel>
#include <QGridLayout>

class DailymotionPlaylistDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit DailymotionPlaylistDialog(Session *session, QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void showNewPlaylistDialog();
    void onItemClicked(const QModelIndex &index);
    void onPlaylistsLoaded();

signals:
    void playlistChosen(const QString &id);
    void addToNewPlaylist(const NewPlaylist &playlist);

private:
    Session *m_session;
    DailymotionUserPlaylistListModel *m_model;
    ListView *m_listView;
    QDialogButtonBox *m_buttonBox;
    QPushButton *m_newButton;
    QLabel *m_noResultsLabel;
    QGridLayout *m_grid;
};

#endif // DAILYMOTIONPLAYLISTDIALOG_H
