#ifndef SHARETOTWITTERDIALOG_H
#define SHARETOTWITTERDIALOG_H

#include "abstractdialog.h"
#include "session.h"
#include <QTextEdit>
#include <QPushButton>
#include <QDialogButtonBox>
#include <QGridLayout>
#include <QScrollArea>
#include <QLabel>

class ShareToTwitterDialog : public AbstractDialog
{
    Q_OBJECT
public:
    explicit ShareToTwitterDialog(Session *session, QSharedPointer<VideoItem> video, QWidget *parent = 0);
    
private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onMessageTextChanged();
    void shareVideo();

private:
    Session *m_session;
    QSharedPointer<VideoItem> m_video;
    QTextEdit *m_messageEdit;
    QLabel *m_charCountLabel;
    QDialogButtonBox *m_buttonBox;
    QPushButton *m_doneButton;
    QScrollArea *m_scrollArea;
    QGridLayout *m_grid;
    QString m_textColor;
};

#endif // SHARETOTWITTERDIALOG_H
