#ifndef LISTVIEW_H
#define LISTVIEW_H

#include <QListView>
#include <QMouseEvent>
#include <QAbstractKineticScroller>

class ListView : public QListView
{
    Q_OBJECT

public:
    explicit ListView(QWidget *parent = 0);
    void keyPressEvent(QKeyEvent *event);
    void mousePressEvent(QMouseEvent *event);
    void mouseReleaseEvent(QMouseEvent *event);

public slots:
    void positionAtBeginning();

private slots:
    void setScrollRange(int minimum, int maximum);
    void onScrollPositionChanged(int position);

signals:
    void atEnd();

private:
    QAbstractKineticScroller *m_kineticScroller;
    int m_minimum;
    int m_maximum;
};

#endif // LISTVIEW_H
