#include "facebookauthdialog.h"

FacebookAuthDialog::FacebookAuthDialog(Session *session, QWidget *parent) :
    AbstractDialog(parent),
    m_session(session),
    m_webView(new WebView(this)),
    m_progressBar(new QProgressBar(this)),
    m_grid(new QGridLayout(this))
{
    setWindowTitle(tr("facebook authorisation"));

    m_grid->addWidget(m_webView, 0, 0);
    m_grid->addWidget(m_progressBar, 1, 0);

    m_webView->setUrl(m_session->sharing()->facebookAuthUrl());
    m_webView->enableSelectionSuppressor();
    m_progressBar->setTextVisible(false);

    connect(m_webView, SIGNAL(urlChanged(QUrl)), this, SLOT(checkUrlForToken(QUrl)));
    connect(m_webView, SIGNAL(loadProgress(int)), m_progressBar, SLOT(setValue(int)));
    connect(m_webView, SIGNAL(loadStarted()), m_progressBar, SLOT(show()));
    connect(m_webView, SIGNAL(loadFinished(bool)), m_progressBar, SLOT(hide()));

    onOrientationChanged();
}

void FacebookAuthDialog::checkUrlForToken(const QUrl &url) {
    QString urlString = url.toString();

    if ((urlString.startsWith("http://www.facebook.com/connect/login_success.html")) || (urlString.startsWith("https://www.facebook.com/connect/login_success.html"))) {
        m_session->sharing()->signInToFacebook(url);
        accept();
    }
}
