#ifndef DAILYMOTIONVIDEOLISTTAB_H
#define DAILYMOTIONVIDEOLISTTAB_H

#include "abstracttab.h"
#include "session.h"
#include "dailymotionvideolistmodel.h"
#include "listview.h"
#include <QAction>
#include <QLabel>
#include <QGridLayout>

class DailymotionVideoListTab : public AbstractTab
{
    Q_OBJECT

public:
    explicit DailymotionVideoListTab(Session *session, QWidget *parent = 0);
    void setVideoFeed(const QString &feed);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void setMenuActions();
    void onLoadingChanged();
    void deleteVideosFromUploads();
    void addVideosToFavourites();
    void deleteVideosFromFavourites();
    void addVideosToPlaylist();
    void addVideoDownloads();
    void addAudioDownloads();
    void queueVideos();
    void showContextMenu(const QPoint &pos);
    void deleteVideoFromUploads();
    void addVideoToFavourites();
    void deleteVideoFromFavourites();
    void showPlaylistDialog();
    void addVideoToPlaylist(const QString &id);
    void addVideoToNewPlaylist(const NewPlaylist &playlist);
    void addVideoDownload();
    void addAudioDownload();
    void queueVideo();
    void onItemClicked(const QModelIndex &index);
    void showVideoInfo(QSharedPointer<VideoItem> video);
    void playVideo(const QModelIndex &index);

private:
    Session *m_session;
    DailymotionVideoListModel *m_model;
    ListView *m_listView;
    QAction *m_deleteFromUploadsAction;
    QAction *m_addToFavouritesAction;
    QAction *m_deleteFromFavouritesAction;
    QAction *m_addToPlaylistAction;
    QAction *m_addToQueueAction;
    QAction *m_videoDownloadAction;
    QAction *m_audioDownloadAction;
    QMenu *m_contextMenu;
    QAction *m_deleteFromUploadsContextAction;
    QAction *m_addToFavouritesContextAction;
    QAction *m_deleteFromFavouritesContextAction;
    QAction *m_addToPlaylistContextAction;
    QAction *m_addToQueueContextAction;
    QAction *m_videoDownloadContextAction;
    QAction *m_audioDownloadContextAction;
    QLabel *m_noResultsLabel;
    QGridLayout *m_grid;
};

#endif // DAILYMOTIONVIDEOLISTTAB_H
