#include "dailymotiongrouplisttab.h"
#include "dailymotiongrouplistdelegate.h"
#include "dailymotionvideolistwindow.h"

DailymotionGroupListTab::DailymotionGroupListTab(Session *session, QWidget *parent) :
    AbstractTab(parent),
    m_session(session),
    m_listView(new ListView(this)),
    m_model(new DailymotionGroupListModel(m_session, this)),
    m_noResultsLabel(new QLabel(QString("<p style='color:#4d4d4d;font-size:40px;'><center><b>%1</b></center></p>").arg(tr("No groups found")), this)),
    m_grid(new QGridLayout(this))
{
    m_grid->setContentsMargins(0, 0, 0, 0);
    m_grid->addWidget(m_listView, 0, 0);
    m_listView->setModel(m_model);
    m_listView->setItemDelegate(new DailymotionGroupListDelegate(m_listView));
    m_noResultsLabel->hide();

    connect(m_model, SIGNAL(loadingChanged()), this, SLOT(onLoadingChanged()));
    connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    connect(m_listView, SIGNAL(atEnd()), m_model, SLOT(getMoreGroups()));

    onOrientationChanged();
}

void DailymotionGroupListTab::setGroupFeed(const QString &feed) {
    m_model->getGroups(feed);
}

void DailymotionGroupListTab::setLandscapeLayout() {
    m_noResultsLabel->setFixedSize(800, 400);
}

void DailymotionGroupListTab::setPortraitLayout() {
    m_noResultsLabel->setFixedSize(480, 700);
}

void DailymotionGroupListTab::onLoadingChanged() {
    m_session->toggleBusy(m_model->loading());
    m_noResultsLabel->setVisible((!m_model->loading()) && (m_model->rowCount() == 0));
}

void DailymotionGroupListTab::onItemClicked(const QModelIndex &index) {
    if (index.isValid()) {
        showGroup(m_model->get(index.row()));
    }
}

void DailymotionGroupListTab::showGroup(QSharedPointer<GroupItem> group) {
    DailymotionVideoListWindow *window = new DailymotionVideoListWindow(m_session, m_session->currentWindow());
    window->setWindowTitle(group.data()->title());
    window->getGroupVideos(group);
    window->show();
}
