#include "abstractcommentlistmodel.h"

AbstractCommentListModel::AbstractCommentListModel(ThumbnailCache *cache, QObject *parent) :
    QAbstractListModel(parent),
    m_cache(cache)
{
    connect(m_cache, SIGNAL(thumbnailReady()), this, SLOT(onThumbnailReady()));
}

AbstractCommentListModel::~AbstractCommentListModel() {
    m_list.clear();
    delete m_cache;
}

int AbstractCommentListModel::rowCount(const QModelIndex &parent) const {
    Q_UNUSED(parent);

    return m_list.size();
}

QVariant AbstractCommentListModel::data(const QModelIndex &index, int role) const {
    switch (role) {
    case IdRole:
        return m_list.at(index.row()).data()->id();
    case BodyRole:
        return m_list.at(index.row()).data()->body();
    case ArtistRole:
        return m_list.at(index.row()).data()->artist();
    case ArtistIdRole:
        return m_list.at(index.row()).data()->artistId();
    case ArtistAvatarRole:
        return m_cache->thumbnail(m_list.at(index.row()).data()->artistAvatarUrl(), QSize(50, 50));
    case DateRole:
        return m_list.at(index.row()).data()->date();
    case VideoIdRole:
        return m_list.at(index.row()).data()->videoId();
    case ReplyIdRole:
        return m_list.at(index.row()).data()->replyId();
    case IndentRole:
        return m_list.at(index.row()).data()->indent();
    case LoadingRole:
        return m_list.at(index.row()).data()->loading();
    default:
        return QVariant();
    }
}

QSharedPointer<CommentItem> AbstractCommentListModel::get(int row) const {
    if ((row >= 0) && (row < m_list.size())) {
        return QSharedPointer<CommentItem>(m_list.at(row));
    }

    return QSharedPointer<CommentItem>();
}

void AbstractCommentListModel::insertComment(int row, QSharedPointer<CommentItem> comment) {
    beginInsertRows(QModelIndex(), row, row);
    m_list.insert(row, comment);
    endInsertRows();
}

void AbstractCommentListModel::appendComment(QSharedPointer<CommentItem> comment) {
    beginInsertRows(QModelIndex(), rowCount(), rowCount());
    m_list.append(comment);
    endInsertRows();
}

bool AbstractCommentListModel::removeComment(const QString &id) {
    bool removed = false;
    int i = 0;

    while ((!removed) && (i < m_list.size())) {
        removed = (get(i).data()->id() == id);

        if (removed) {
            removeRow(i);
        }

        i++;
    }

    return removed;
}

bool AbstractCommentListModel::removeRow(int row, const QModelIndex &parent)
{
    Q_UNUSED(parent);

    if ((row >= 0) && (row < m_list.size())) {
        beginRemoveRows(QModelIndex(), row, row);
        m_list.takeAt(row).clear();
        endRemoveRows();

        return true;
    }

    return false;
}

void AbstractCommentListModel::onThumbnailReady() {
    emit dataChanged(index(0), index(rowCount() - 1));
}
