#ifndef YOUTUBEVIDEOLISTWINDOW_H
#define YOUTUBEVIDEOLISTWINDOW_H

#include "stackedwindow.h"
#include "youtubevideolistmodel.h"
#include "listview.h"
#include <QAction>
#include <QLabel>

class YouTubeVideoListWindow : public StackedWindow
{
    Q_OBJECT
public:
    explicit YouTubeVideoListWindow(Session *session, QWidget *parent);
    void setVideoFeed(const QString &feed);
    void getRelatedVideos(const QString &id);
    void search(const QString &query,
                Queries::QueryOrder order,
                Queries::TimeFilter time,
                Queries::DurationFilter duration,
                const QString &language);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void setMenuActions();
    void onLoadingChanged();
    void deleteVideosFromUploads();
    void addVideosToFavourites();
    void deleteVideosFromFavourites();
    void addVideosToPlaylist();
    void addVideosToWatchLaterPlaylist();
    void addVideoDownloads();
    void addAudioDownloads();
    void queueVideos();
    void showContextMenu(const QPoint &pos);
    void deleteVideoFromUploads();
    void addVideoToFavourites();
    void deleteVideoFromFavourites();
    void showPlaylistDialog();
    void addVideoToPlaylist(const QString &id);
    void addVideoToNewPlaylist(const NewPlaylist &playlist);
    void addVideoToWatchLaterPlaylist();
    void addVideoDownload();
    void addAudioDownload();
    void queueVideo();
    void onItemClicked(const QModelIndex &index);
    void showVideoInfo(QSharedPointer<VideoItem> video);
    void playVideo(const QModelIndex &index);

private:
    ListView *m_listView;
    YouTubeVideoListModel *m_model;
    QAction *m_deleteFromUploadsAction;
    QAction *m_addToFavouritesAction;
    QAction *m_deleteFromFavouritesAction;
    QAction *m_addToPlaylistAction;
    QAction *m_watchLaterAction;
    QAction *m_addToQueueAction;
    QAction *m_videoDownloadAction;
    QAction *m_audioDownloadAction;
    QMenu *m_contextMenu;
    QAction *m_deleteFromUploadsContextAction;
    QAction *m_addToFavouritesContextAction;
    QAction *m_deleteFromFavouritesContextAction;
    QAction *m_addToPlaylistContextAction;
    QAction *m_watchLaterContextAction;
    QAction *m_addToQueueContextAction;
    QAction *m_videoDownloadContextAction;
    QAction *m_audioDownloadContextAction;
    QLabel *m_noResultsLabel;
};

#endif // YOUTUBEVIDEOLISTWINDOW_H
