#ifndef YOUTUBEPROFILETAB_H
#define YOUTUBEPROFILETAB_H

#include "abstracttab.h"
#include "session.h"
#include "useritem.h"
#include "separatorlabel.h"
#include "avatarlabel.h"
#include <QLabel>
#include <QPushButton>
#include <QScrollArea>
#include <QAction>
#include <QGridLayout>

class YouTubeProfileTab : public AbstractTab
{
    Q_OBJECT

public:
    explicit YouTubeProfileTab(Session *session, const QString &userId, QWidget *parent = 0);
    
private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void setUser(QSharedPointer<UserItem> user);
    void setAvatar();
    void onProfileError();
    void toggleSubscription();
    void onSubscribedChanged();
    void showUserWebsite();
    void showUploadDialog();
    void showWatchLaterPlaylist();
    void showWatchHistory();
    
private:
    Session *m_session;
    QSharedPointer<UserItem> m_user;
    AvatarLabel *m_avatar;
    QLabel *m_channelLabel;
    QLabel *m_videosLabel;
    QLabel *m_subscribersLabel;
    QLabel *m_viewsLabel;
    QLabel *m_ageLabel;
    QLabel *m_genderLabel;
    QLabel *m_locationLabel;
    QLabel *m_websiteLabel;
    QLabel *m_descriptionLabel;
    QLabel *m_noProfileLabel;
    QPushButton *m_subscriptionButton;
    QAction *m_watchLaterAction;
    QAction *m_watchHistoryAction;
    QAction *m_uploadAction;
    QScrollArea *m_scrollArea;
    QGridLayout *m_grid;
};

#endif // YOUTUBEPROFILETAB_H
