#include "videoservicedialog.h"
#include "textlistdelegate.h"

VideoServiceDialog::VideoServiceDialog(QWidget *parent) :
    AbstractDialog(parent),
    m_model(new VideoServiceModel(this)),
    m_listView(new ListView(this)),
    m_grid(new QGridLayout(this))
{
    setWindowTitle(tr("Choose service"));

    m_grid->addWidget(m_listView, 0, 0);

    m_listView->setModel(m_model);
    m_listView->setItemDelegate(new TextListDelegate(Qt::AlignCenter, m_listView));

    connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));

    onOrientationChanged();
}

void VideoServiceDialog::setLandscapeLayout() {
    setFixedHeight(340);
}

void VideoServiceDialog::setPortraitLayout() {
    setFixedHeight(600);
}

void VideoServiceDialog::onItemClicked(const QModelIndex &index) {
    emit valueChanged(static_cast<Services::VideoService>(m_model->value(index.row()).toInt()));
    accept();
}
