#include "searchtypeselector.h"

SearchTypeSelector::SearchTypeSelector(const QString &text, QWidget *parent) :
    QMaemo5ValueButton(text, parent),
    m_model(new SearchTypeModel(this)),
    m_selector(new QMaemo5ListPickSelector(this))
{
    m_selector->setModel(m_model);
    m_selector->setModelColumn(0);
    setPickSelector(m_selector);
    connect(m_selector, SIGNAL(selected(QString)), this, SLOT(onSelected()));
}

void SearchTypeSelector::setValue(Queries::QueryType value) {
    bool found = false;
    int i = 0;

    while ((!found) && (i < m_model->rowCount())) {
        found = static_cast<Queries::QueryType>(m_model->value(i).toInt()) == value;

        if (found) {
            m_selector->setCurrentIndex(i);
        }

        i++;
    }

    if (!found) {
        m_selector->setCurrentIndex(0);
    }
}

Queries::QueryType SearchTypeSelector::currentValue() {
    return static_cast<Queries::QueryType>(m_model->value(m_selector->currentIndex()).toInt());
}

void SearchTypeSelector::onSelected() {
    emit valueChanged(currentValue());
}

void SearchTypeSelector::showGroups(bool show) {
    m_model->showGroups(show);
}
