#include "searchdurationselector.h"

SearchDurationSelector::SearchDurationSelector(const QString &text, QWidget *parent) :
    QMaemo5ValueButton(text, parent),
    m_model(new SearchDurationModel(this)),
    m_selector(new QMaemo5ListPickSelector(this))
{
    m_selector->setModel(m_model);
    m_selector->setModelColumn(0);
    setPickSelector(m_selector);
    connect(m_selector, SIGNAL(selected(QString)), this, SLOT(onSelected()));
}

void SearchDurationSelector::setValue(Queries::DurationFilter value) {
    bool found = false;
    int i = 0;

    while ((!found) && (i < m_model->rowCount())) {
        found = static_cast<Queries::DurationFilter>(m_model->value(i).toInt()) == value;

        if (found) {
            m_selector->setCurrentIndex(i);
        }

        i++;
    }

    if (!found) {
        m_selector->setCurrentIndex(0);
    }
}

Queries::DurationFilter SearchDurationSelector::currentValue() {
    return static_cast<Queries::DurationFilter>(m_model->value(m_selector->currentIndex()).toInt());
}

void SearchDurationSelector::onSelected() {
    emit valueChanged(currentValue());
}
