#ifndef DAILYMOTIONCHANNELWINDOW_H
#define DAILYMOTIONCHANNELWINDOW_H

#include "stackedwindow.h"
#include "dailymotionprofiletab.h"
#include "dailymotionvideolisttab.h"
#include "dailymotionplaylistlisttab.h"
#include "dailymotiongrouplisttab.h"
#include "dailymotionuserlisttab.h"
#include <QStackedWidget>
#include <QActionGroup>
#include <QMenu>

class DailymotionChannelWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit DailymotionChannelWindow(Session *session, const QString &userId, QWidget *parent);

private:
    void clearMenuActions();

private slots:
    void showProfile();
    void showUploads();
    void showFavourites();
    void showPlaylists();
    void showGroups();
    void showSubscriptions();

private:
    QString m_userId;
    QMenu *m_menu;
    QActionGroup *m_actionGroup;
    QAction *m_profileAction;
    QAction *m_uploadsAction;
    QAction *m_favouritesAction;
    QAction *m_playlistsAction;
    QAction *m_groupsAction;
    QAction *m_subscriptionsAction;
    QStackedWidget *m_tabWidget;
    DailymotionProfileTab *m_profileTab;
    DailymotionVideoListTab *m_uploadsTab;
    DailymotionVideoListTab *m_favouritesTab;
    DailymotionPlaylistListTab *m_playlistsTab;
    DailymotionGroupListTab *m_groupsTab;
    DailymotionUserListTab *m_subscriptionsTab;
};

#endif // DAILYMOTIONCHANNELWINDOW_H
