#ifndef ARCHIVEWINDOW_H
#define ARCHIVEWINDOW_H

#include "stackedwindow.h"
#include "archivelistmodel.h"
#include "listview.h"
#include "filterbox.h"
#include <QMenu>
#include <QAction>
#include <QLabel>
#include <QVBoxLayout>

class ArchiveWindow : public StackedWindow
{
    Q_OBJECT
public:
    explicit ArchiveWindow(Session *session, StackedWindow *parent);
    void keyPressEvent(QKeyEvent *event);
    
private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onDirectoryLoaded();
    void onItemClicked(const QModelIndex &index);
    void showContextMenu(const QPoint &pos);
    void showConfirmDeleteDialog();
    void deleteVideo();
    void showFilterBox();

private:
    ArchiveListModel *m_model;
    ListView *m_listView;
    FilterBox *m_filterBox;
    QMenu *m_contextMenu;
    QAction *m_deleteAction;
    QLabel *m_noResultsLabel;
    QVBoxLayout *m_vbox;
};

#endif // ARCHIVEWINDOW_H
