#ifndef ACCOUNTSDIALOG_H
#define ACCOUNTSDIALOG_H

#include "abstractdialog.h"
#include "dailymotionaccountslistmodel.h"
#include "youtubeaccountslistmodel.h"
#include "listview.h"
#include "session.h"
#include "separatorlabel.h"
#include <QPushButton>
#include <QLineEdit>
#include <QGridLayout>
#include <QScrollArea>
#include <QMenu>
#include <QAction>

class AccountsDialog : public AbstractDialog
{
    Q_OBJECT
public:
    explicit AccountsDialog(Session *session, QWidget *parent = 0);
    
private:
    inline void setLandscapeLayout() { setFixedHeight(340); }
    inline void setPortraitLayout() { setFixedHeight(600); }
    void showFacebookAuthDialog();
    void showTwitterAuthDialog();

private slots:
    void showYouTubeAuthDialog();
    void showDailymotionAuthDialog();
    void onFacebookButtonClicked();
    void onTwitterButtonClicked();
    void switchYouTubeAccount(const QModelIndex &index);
    void switchDailymotionAccount(const QModelIndex &index);
    void showYouTubeContextMenu(const QPoint &pos);
    void showDailymotionContextMenu(const QPoint &pos);
    void deleteYouTubeAccount();
    void deleteDailymotionAccount();
    void onSignedInOrOutOfYouTube();
    void onSignedInOrOutOfDailymotion();
    void onSignedInOrOutOfFacebook();
    void onSignedInOrOutOfTwitter();

private:
    Session *m_session;
    DailymotionAccountsListModel *m_dailymotionModel;
    YouTubeAccountsListModel *m_youtubeModel;
    ListView *m_dailymotionView;
    ListView *m_youtubeView;
    QLineEdit *m_dailymotionEdit;
    QLineEdit *m_youtubeEdit;
    QLabel *m_dailymotionLabel;
    QLabel *m_youtubeLabel;
    QLabel *m_facebookLabel;
    QLabel *m_twitterLabel;
    QPushButton *m_youtubeButton;
    QPushButton *m_dailymotionButton;
    QPushButton *m_facebookButton;
    QPushButton *m_twitterButton;
    QScrollArea *m_scrollArea;
    QMenu *m_contextMenu;
    QAction *m_dailymotionDeleteAction;
    QAction *m_youtubeDeleteAction;
    QGridLayout *m_grid;
};

#endif // ACCOUNTSDIALOG_H
