#ifndef ABSTRACTGROUPLISTMODEL_H
#define ABSTRACTGROUPLISTMODEL_H

#include "groupitem.h"
#include <QAbstractListModel>
#include <QSharedPointer>

class AbstractGroupListModel : public QAbstractListModel
{
    Q_OBJECT

public:
    enum Roles {

        IdRole = Qt::UserRole+1,
        TitleRole,
        ArtistRole,
        DateRole,
        DescriptionRole
    };

public:
    explicit AbstractGroupListModel(QObject *parent = 0);
    ~AbstractGroupListModel();
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role) const;
    QSharedPointer<GroupItem> get(int row) const;
    void insertGroup(int row, QSharedPointer<GroupItem> group);
    void appendGroup(QSharedPointer<GroupItem> group);
    bool removeGroup(const QString &id);
    
protected:
    bool removeRow(int row, const QModelIndex &parent = QModelIndex());

protected:
    QList< QSharedPointer<GroupItem> > m_list;
};

#endif // ABSTRACTGROUPLISTMODEL_H
