#include "youtubeuserlistdelegate.h"
#include "abstractuserlistmodel.h"
#include <QApplication>

YouTubeUserListDelegate::YouTubeUserListDelegate(QListView *parent) :
    QStyledItemDelegate(parent),
    m_view(parent)
{
}

void YouTubeUserListDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    if ((option.state) & (QStyle::State_Selected)) {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundPressed.png"));
    }
    else {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundNormal.png"));
    }

    QRect imageRect = option.rect;
    imageRect.moveTopLeft(QPoint(imageRect.left() + 5, imageRect.top() + 5));
    imageRect.setSize(QSize(60, 60));

    QImage image = index.data(AbstractUserListModel::AvatarRole).value<QImage>();

    if (!image.isNull()) {
        painter->drawImage(imageRect, image);
    }

    QPen oldPen = painter->pen();
    painter->setPen(QColor("#4d4d4d"));
    painter->drawRect(imageRect);

    painter->setPen(oldPen);

    QRect textRect = option.rect;
    textRect.setTopLeft(QPoint(imageRect.right() + 5, imageRect.top()));
    textRect.setRight(textRect.right() - 5);
    textRect.setHeight(60);

    painter->drawText(textRect, Qt::TextWordWrap, index.data(AbstractUserListModel::UsernameRole).toString());

    textRect.moveTop(textRect.bottom() + 5);

    QFont oldFont = painter->font();
    QFont smallFont;
    smallFont.setPixelSize(18);
    painter->setFont(smallFont);

    int videoCount = index.data(AbstractUserListModel::VideoCountRole).toInt();

    painter->drawText(textRect, !videoCount ? tr("No videos") : QString("%1 %2").arg(videoCount).arg(tr("videos")));
    painter->setFont(oldFont);
}

QSize YouTubeUserListDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(option);
    Q_UNUSED(index);

    return QSize(m_view->width(), 100);
}
