#include "youtubesubscriptionstab.h"
#include "youtubeuserlistdelegate.h"
#include "youtubechannelwindow.h"
#include "youtubevideolistwindow.h"

YouTubeSubscriptionsTab::YouTubeSubscriptionsTab(Session *session, QWidget *parent) :
    AbstractTab(parent),
    m_session(session),
    m_model(new YouTubeSubscriptionListModel(session, this)),
    m_listView(new ListView(this)),
    m_contextMenu(new QMenu(this)),
    m_unsubscribeAction(m_contextMenu->addAction(tr("Unsubscribe"), this, SLOT(unsubscribe()))),
    m_videosAction(new QAction(tr("Latest videos"), this)),
    m_noResultsLabel(new QLabel(QString("<p style='color:#4d4d4d;font-size:40px;'><center><b>%1</b></center></p>").arg(tr("No subscriptions found")), this)),
    m_grid(new QGridLayout(this))
{
    addAction(m_videosAction);

    m_grid->setContentsMargins(0, 0, 0, 0);
    m_grid->addWidget(m_listView, 0, 0);
    m_listView->setItemDelegate(new YouTubeUserListDelegate(m_listView));
    m_noResultsLabel->hide();

    if (m_session->youtube()->subscriptionsLoaded()) {
        onSubscriptionsLoaded();
    }
    else {
        m_session->toggleBusy(true);
        connect(m_session->youtube(), SIGNAL(allSubscriptionsLoaded()), this, SLOT(onSubscriptionsLoaded()));
    }

    connect(m_videosAction, SIGNAL(triggered()), this, SLOT(showSubscriptionVideos()));

    onOrientationChanged();
}

void YouTubeSubscriptionsTab::setLandscapeLayout() {
    m_noResultsLabel->setFixedSize(800, 400);
}

void YouTubeSubscriptionsTab::setPortraitLayout() {
    m_noResultsLabel->setFixedSize(480, 700);
}

void YouTubeSubscriptionsTab::onSubscriptionsLoaded() {
    m_session->toggleBusy(false);
    m_listView->setModel(m_model);
    m_noResultsLabel->setVisible(m_model->rowCount() == 0);

    connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    connect(m_listView, SIGNAL(customContextMenuRequested(QPoint)), this, SLOT(showContextMenu(QPoint)));
}

void YouTubeSubscriptionsTab::onItemClicked(const QModelIndex &index) {
    if (index.isValid()) {
        showUserChannel(index.data(YouTubeSubscriptionListModel::IdRole).toString());
    }
}

void YouTubeSubscriptionsTab::showUserChannel(const QString &userId) {
    YouTubeChannelWindow *window = new YouTubeChannelWindow(m_session, userId, m_session->currentWindow());
    window->show();
}

void YouTubeSubscriptionsTab::showSubscriptionVideos() {
    YouTubeVideoListWindow *window = new YouTubeVideoListWindow(m_session, m_session->currentWindow());
    window->setVideoFeed(YOUTUBE_NEW_SUBSCRIPTION_VIDEOS_FEED);
    window->show();
}

void YouTubeSubscriptionsTab::showContextMenu(const QPoint &pos) {
    m_contextMenu->popup(pos, m_unsubscribeAction);
}

void YouTubeSubscriptionsTab::unsubscribe() {
    m_session->youtube()->unsubscribe(m_model->get(m_listView->currentIndex().row()));
}
