#ifndef TRANSFERPRIORITYDIALOG_H
#define TRANSFERPRIORITYDIALOG_H

#include "abstractdialog.h"
#include "selectionmodels.h"
#include <QListView>
#include <QGridLayout>

class TransferPriorityDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit TransferPriorityDialog(QWidget *parent = 0);
    TransferItem::Priority currentValue() const;
    void setValue(TransferItem::Priority priority);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onItemClicked(const QModelIndex &index);
    
signals:
    void valueChanged(TransferItem::Priority priority);

private:
    TransferPriorityModel *m_model;
    QListView *m_listView;
    QGridLayout *m_grid;
};

#endif // TRANSFERPRIORITYDIALOG_H
